(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     72302,       2123]
NotebookOptionsPosition[     66662,       1938]
NotebookOutlinePosition[     67267,       1959]
CellTagsIndexPosition[     67224,       1956]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fraunhofer\[CloseCurlyQuote]s doublets", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["Fraunhofer",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["thick",
           FontWeight->Bold], Cell["thickness of the corrector"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]},
         {Cell["focal",
           FontWeight->Bold], Cell["focal"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["FraunhoferInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Third-order project of a Fraunhofer\[CloseCurlyQuote]s doublets", \
"Title"],

Cell["\<\
First, we consider  a doublet of thin lenses and evaluate its focal length \
and the condition of axial chromatism (the variables c1,c2,c3,c4,N1, N2, \
N2b,N1r,N2r,r, x, \[Theta], \[Lambda], \[Lambda]b, \[Lambda]r have to be \
unassigned, for that we use Clear)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "c1", ",", "c2", ",", "c3", ",", "c4", ",", "N1", ",", " ", "N2", ",", " ",
     "N2b", ",", "N1r", ",", "N2r", ",", "r", ",", " ", "x", ",", " ", 
    "\[Theta]", ",", " ", "\[Lambda]", ",", " ", "\[Lambda]b", ",", " ", 
    "\[Lambda]r"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "N1", ",", "1", ",", "N2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N1b", ",", "1", ",", "N2b", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N1r", ",", "1", ",", "N2r", ",", "1"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "\[Lambda]b", ",", "\[Lambda]r"}], "}"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TotalAberrations", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "c1"}], ",", " ", 
      RowBox[{"1", "/", "c2"}], ",", " ", 
      RowBox[{"1", "/", "c3"}], ",", " ", 
      RowBox[{"1", "/", "c4"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", "ind", ",",
     " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
    " ", "r", ",", " ", "0", ",", " ", "0", ",", " ", 
    RowBox[{"-", "Infinity"}], ",", " ", "y1", ",", "\[Theta]", ",", " ", 
    "waves"}], "]"}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"GOfocalLength", "[", 
        RowBox[{"[", "1", "]"}], "]"}]], "-", 
      FractionBox["1", "f"]}], "]"}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "-", 
  RowBox[{"c3", " ", "f"}], "+", 
  RowBox[{"c4", " ", "f"}], "+", 
  RowBox[{"c1", " ", "f", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "N1"}], ")"}]}], "+", 
  RowBox[{"c2", " ", 
   RowBox[{"(", 
    RowBox[{"f", "-", 
     RowBox[{"f", " ", "N1"}]}], ")"}]}], "+", 
  RowBox[{"c3", " ", "f", " ", "N2"}], "-", 
  RowBox[{"c4", " ", "f", " ", "N2"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"GOdistancegauss", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "GOn"}], "]"}], "]"}]], "-", 
      FractionBox["1", 
       RowBox[{"GOdistancegauss", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "GOn"}], "]"}], "]"}]]}], "]"}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"c1", " ", 
   RowBox[{"(", 
    RowBox[{"N1b", "-", "N1r"}], ")"}]}], "+", 
  RowBox[{"c2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "N1b"}], "+", "N1r"}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"c3", "-", "c4"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"N2b", "-", "N2r"}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
By introducing the new variables \[Xi]1 = (c1 - c2) f, \[Xi]2 = (c3 - c4) f, \
the above equations become\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq01", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]1", " ", 
      RowBox[{"(", 
       RowBox[{"N1", "-", "1"}], ")"}]}], "+", 
     RowBox[{"\[Xi]2", " ", 
      RowBox[{"(", " ", 
       RowBox[{"N2", "-", "1"}], ")"}]}]}], "\[Equal]", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq02", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Xi]1", 
      RowBox[{"(", 
       RowBox[{"N1b", "-", "N1r"}], ")"}]}], "+", 
     RowBox[{"\[Xi]2", " ", 
      RowBox[{"(", 
       RowBox[{"N2b", "-", "N2r"}], ")"}]}]}], "\[Equal]", "0"}]}], 
  ";"}]}], "Input"],

Cell[TextData[{
 "If Vi = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"(", 
     RowBox[{"Ni", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"Nib", "-", "Nir"}], ")"}]], TraditionalForm]]],
 " and \[Alpha]i = Nib-Nir, the above system becomes"
}], "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq11", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Alpha]", "1"], " ", 
      SubscriptBox["V", "1"], "\[Xi]1"}], " ", "+", 
     RowBox[{
      SubscriptBox["\[Alpha]", "2"], 
      SubscriptBox["V", "2"], "\[Xi]2"}]}], " ", "\[Equal]", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq12", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Alpha]", "1"], "\[Xi]1"}], "+", 
     RowBox[{
      SubscriptBox["\[Alpha]", "2"], "\[Xi]2"}]}], " ", "\[Equal]", "0"}]}], 
  ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq11", ",", "eq12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Xi]1", ",", "\[Xi]2"}], "}"}]}], "]"}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Xi]1", "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["V", "1"], "-", 
        SubscriptBox["V", "2"]}], ")"}], " ", 
      SubscriptBox["\[Alpha]", "1"]}]]}], ",", 
   RowBox[{"\[Xi]2", "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["V", "1"], "-", 
         SubscriptBox["V", "2"]}], ")"}], " ", 
       SubscriptBox["\[Alpha]", "2"]}]]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Finally, we have", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sost", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c1", "\[Rule]", 
      RowBox[{"c2", "+", 
       RowBox[{"s1", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], ",", 
     RowBox[{"c3", "\[Rule]", 
      RowBox[{"c4", "+", 
       RowBox[{"s1", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}]}]}]}], "}"}]}], ";"}]], "Input"],

Cell["Coma vanishes if", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqco", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Together", "[", 
     RowBox[{"GOComaCoefficient", "/.", "sost"}], "]"}], "//", "Numerator"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["N1", "2"]}], "+", 
     SuperscriptBox["N1", "3"]}], ")"}], " ", "N2", " ", 
   SubsuperscriptBox["\[Alpha]", "2", "2"]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "N1"}], ")"}], " ", 
   SubscriptBox["\[Alpha]", "1"], " ", 
   SubscriptBox["\[Alpha]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"N1", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", "N2", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["N2", "2"]}]}], ")"}]}], "+", 
     RowBox[{"c2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "N1"}], ")"}], " ", "N2", " ", 
      SubscriptBox["V", "1"], " ", 
      SubscriptBox["\[Alpha]", "2"]}], "-", 
     RowBox[{"c2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "N1"}], ")"}], " ", "N2", " ", 
      SubscriptBox["V", "2"], " ", 
      SubscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
  RowBox[{"N1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "N2"}], ")"}], " ", 
   SubsuperscriptBox["\[Alpha]", "1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "N2", "+", 
     SuperscriptBox["N2", "2"], "+", 
     RowBox[{"c4", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "N2"}], ")"}], " ", 
      SubscriptBox["V", "1"], " ", 
      SubscriptBox["\[Alpha]", "2"]}], "-", 
     RowBox[{"c4", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "N2"}], ")"}], " ", 
      SubscriptBox["V", "2"], " ", 
      SubscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"a1", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqco", ",", "c2"}], "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"a2", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqco", ",", "c4"}], "]"}], "//", "Simplify"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["N1", "2"]}], ")"}]}], " ", "N2", " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["V", "1"], "-", 
    SubscriptBox["V", "2"]}], ")"}], " ", 
  SubscriptBox["\[Alpha]", "1"], " ", 
  SubsuperscriptBox["\[Alpha]", "2", "2"]}]], "Output"],

Cell[BoxData[
 RowBox[{"N1", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["N2", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["V", "1"], "-", 
    SubscriptBox["V", "2"]}], ")"}], " ", 
  SubsuperscriptBox["\[Alpha]", "1", "2"], " ", 
  SubscriptBox["\[Alpha]", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a0", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"eqco", ",", "c2", ",", "0"}], "]"}], "/.", 
    RowBox[{"c4", "\[Rule]", "0"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"N1", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["N2", "2"]}], "+", 
     SuperscriptBox["N2", "3"]}], ")"}], " ", 
   SubsuperscriptBox["\[Alpha]", "1", "2"]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "N1"}], ")"}], " ", "N1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "N2", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["N2", "2"]}]}], ")"}], " ", 
   SubscriptBox["\[Alpha]", "1"], " ", 
   SubscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["N1", "2"]}], "+", 
     SuperscriptBox["N1", "3"]}], ")"}], " ", "N2", " ", 
   SubsuperscriptBox["\[Alpha]", "2", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"eqco", "-", 
   RowBox[{"a1", " ", "c2"}], "-", 
   RowBox[{"a2", " ", "c4"}], "-", "a0"}], " ", "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell["Finally, coma vanishes if", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", "a1", ")"}], " ", "c2"}], "+", 
   RowBox[{
    RowBox[{"(", "a2", ")"}], " ", "c4"}], "+", 
   RowBox[{"(", "a0", ")"}]}], "\[Equal]", "0"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N1", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["N2", "2"]}], "+", 
      SuperscriptBox["N2", "3"]}], ")"}], " ", 
    SubsuperscriptBox["\[Alpha]", "1", "2"]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "N1"}], ")"}], " ", "N1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "N2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["N2", "2"]}]}], ")"}], " ", 
    SubscriptBox["\[Alpha]", "1"], " ", 
    SubscriptBox["\[Alpha]", "2"]}], "+", 
   RowBox[{"c4", " ", "N1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["N2", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["V", "1"], "-", 
      SubscriptBox["V", "2"]}], ")"}], " ", 
    SubsuperscriptBox["\[Alpha]", "1", "2"], " ", 
    SubscriptBox["\[Alpha]", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["N1", "2"]}], "+", 
      SuperscriptBox["N1", "3"]}], ")"}], " ", "N2", " ", 
    SubsuperscriptBox["\[Alpha]", "2", "2"]}], "-", 
   RowBox[{"c2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["N1", "2"]}], ")"}], " ", "N2", " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["V", "1"], "-", 
      SubscriptBox["V", "2"]}], ")"}], " ", 
    SubscriptBox["\[Alpha]", "1"], " ", 
    SubsuperscriptBox["\[Alpha]", "2", "2"]}]}], "\[Equal]", "0"}]], "Output"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqsp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Together", "[", 
      RowBox[{"GOSphericalCoefficient", "/.", "sost"}], "]"}], "//", 
     "Numerator"}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b20", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqsp", ",", 
     SuperscriptBox["c2", "2"]}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "N1", "+", 
     SuperscriptBox["N1", "2"]}], ")"}]}], " ", "N2", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["V", "1"], "-", 
     SubscriptBox["V", "2"]}], ")"}], "2"], " ", 
  SubsuperscriptBox["\[Alpha]", "1", "2"], " ", 
  SubsuperscriptBox["\[Alpha]", "2", "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b02", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqsp", ",", 
     SuperscriptBox["c4", "2"]}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"N1", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "N2", "+", 
    SuperscriptBox["N2", "2"]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["V", "1"], "-", 
     SubscriptBox["V", "2"]}], ")"}], "2"], " ", 
  SubsuperscriptBox["\[Alpha]", "1", "3"], " ", 
  SubsuperscriptBox["\[Alpha]", "2", "2"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b11", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqsp", ",", 
     RowBox[{"c2", " ", "c4"}]}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b10", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqsp", ",", "c2"}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", "-", 
    RowBox[{"3", " ", "N1"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["N1", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["N1", "3"]}]}], ")"}], " ", "N2", " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["V", "1"], "-", 
    SubscriptBox["V", "2"]}], ")"}], " ", 
  SubscriptBox["\[Alpha]", "1"], " ", 
  SubsuperscriptBox["\[Alpha]", "2", "3"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b01", "=", 
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"eqsp", ",", "c4"}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"N1", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "N2"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["V", "1"], "-", 
    SubscriptBox["V", "2"]}], ")"}], " ", 
  SubsuperscriptBox["\[Alpha]", "1", "2"], " ", 
  SubscriptBox["\[Alpha]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "-", "N2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["N2", "2"]}]}], ")"}], " ", 
     SubscriptBox["\[Alpha]", "1"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "N1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "N2"}], ")"}], " ", 
     SubscriptBox["\[Alpha]", "2"]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b00", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"eqsp", "-", 
     RowBox[{"b20", " ", 
      SuperscriptBox["c2", "2"]}], "-", 
     RowBox[{"b02", " ", 
      SuperscriptBox["c4", "2"]}], "-", 
     RowBox[{"b10", " ", "c2"}], " ", "-", 
     RowBox[{"b01", " ", "c4"}]}], "]"}], "//", "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"N1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"2", " ", "N2"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["N2", "2"]}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["N2", "3"]}], "+", 
     SuperscriptBox["N2", "4"]}], ")"}], " ", 
   SubsuperscriptBox["\[Alpha]", "1", "3"]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "N1"}], ")"}], " ", "N1", " ", 
   RowBox[{"(", 
    RowBox[{"4", "-", "N2", "-", 
     RowBox[{"6", " ", 
      SuperscriptBox["N2", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["N2", "3"]}]}], ")"}], " ", 
   SubsuperscriptBox["\[Alpha]", "1", "2"], " ", 
   SubscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "N1"}], ")"}], "2"], " ", "N1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", "N2", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["N2", "2"]}]}], ")"}], " ", 
   SubscriptBox["\[Alpha]", "1"], " ", 
   SubsuperscriptBox["\[Alpha]", "2", "2"]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"2", " ", "N1"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["N1", "2"]}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["N1", "3"]}], "+", 
     SuperscriptBox["N1", "4"]}], ")"}], " ", "N2", " ", 
   SubsuperscriptBox["\[Alpha]", "2", "3"]}]}]], "Output"]
}, Open  ]],

Cell["For the glasses BaK1-FK54 we have", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sost1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"N1", "->", "1.5725001"}], ",", 
     RowBox[{"N2", "->", " ", "1.43700005"}], ",", 
     RowBox[{"N1b", "->", " ", "1.57943481"}], ",", " ", 
     RowBox[{"N2b", "->", " ", "1.44033746"}], ",", 
     RowBox[{"N1r", "->", "1.56948667"}], ",", 
     RowBox[{"N2r", "->", " ", "1.43551944"}], ",", 
     RowBox[{"f", "\[Rule]", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sost2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Alpha]", "1"], "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"N1b", "-", "N1r"}], ")"}]}], ",", 
     RowBox[{
      SubscriptBox["\[Alpha]", "2"], "->", 
      RowBox[{"(", 
       RowBox[{"N2b", "-", "N2r"}], ")"}]}], ",", 
     RowBox[{
      SubscriptBox["V", "1"], "->", 
      FractionBox[
       RowBox[{"N1", "-", "1"}], 
       RowBox[{"N1b", "-", "N1r"}]]}], ",", 
     RowBox[{
      SubscriptBox["V", "2"], "->", 
      FractionBox[
       RowBox[{"N2", "-", "1"}], 
       RowBox[{"N2b", "-", "N2r"}]]}]}], "}"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"eq1", "/.", "sost2"}], ")"}], "/.", "sost1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"0.5725001000000001`", " ", "c1"}], "-", 
  RowBox[{"0.5725001000000001`", " ", "c2"}], "+", 
  RowBox[{"0.43700005`", " ", "c3"}], "-", 
  RowBox[{"0.43700005`", " ", "c4"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"eq2", "/.", "sost2"}], ")"}], "/.", "sost1"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.009948139999999883`", " ", "c1"}], "-", 
  RowBox[{"0.009948139999999883`", " ", "c2"}], "+", 
  RowBox[{"0.0048180200000000895`", " ", "c3"}], "-", 
  RowBox[{"0.0048180200000000895`", " ", "c4"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"eqco", "/.", "sost2"}], ")"}], "/.", "sost1"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.00010025526434124851`"}], "+", 
  RowBox[{"0.000016202644977447012`", " ", "c2"}], "-", 
  RowBox[{"0.000026472756329334533`", " ", "c4"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"eqsp", "/.", "sost2"}], ")"}], "/.", "sost1"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"1.2049948657710708`*^-6", "+", 
  RowBox[{"1.9026444139673225`*^-8", " ", "c2"}], "-", 
  RowBox[{"3.575463365861846`*^-8", " ", 
   SuperscriptBox["c2", "2"]}], "+", 
  RowBox[{"4.3332878532825975`*^-7", " ", "c4"}], "+", 
  RowBox[{"5.932704670586379`*^-8", " ", 
   SuperscriptBox["c4", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soluz1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"equaz1", "\[Equal]", "0"}], ",", 
       RowBox[{"equaz2", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c1", ",", "c3"}], "}"}]}], "]"}], "//", "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c1", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "3.032068658213773`"}], "+", 
     RowBox[{"1.`", " ", "c2"}]}]}], ",", 
   RowBox[{"c3", "\[Rule]", 
    RowBox[{"6.260547590404741`", "\[VeryThinSpace]", "-", 
     RowBox[{"4.440892098500626`*^-16", " ", "c2"}], "+", 
     RowBox[{"1.`", " ", "c4"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz31", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"equaz3", "/.", "soluz1"}], ")"}], 
    RowBox[{"10", "^", "5"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "10.025526434124851`"}], "+", 
  RowBox[{"1.6202644977447012`", " ", "c2"}], "-", 
  RowBox[{"2.6472756329334532`", " ", "c4"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz41", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"equaz4", "/.", "soluz1"}], ")"}], 
    RowBox[{"10", "^", "8"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"120.49948657710708`", "\[VeryThinSpace]", "+", 
  RowBox[{"1.9026444139673224`", " ", "c2"}], "-", 
  RowBox[{"3.5754633658618458`", " ", 
   SuperscriptBox["c2", "2"]}], "+", 
  RowBox[{"43.33287853282597`", " ", "c4"}], "+", 
  RowBox[{"5.932704670586379`", " ", 
   SuperscriptBox["c4", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soluz2", "=", 
  RowBox[{"Quiet", "@", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"equaz31", "\[Equal]", "0"}], ",", 
       RowBox[{"equaz41", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c2", ",", "c4"}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c2", "\[Rule]", 
      RowBox[{"-", "5.206806425683197`"}]}], ",", 
     RowBox[{"c4", "\[Rule]", 
      RowBox[{"-", "6.973935695479736`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c2", "\[Rule]", "5.888001490502729`"}], ",", 
     RowBox[{"c4", "\[Rule]", 
      RowBox[{"-", "0.18336082966076114`"}]}]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"equaz31", "\[Equal]", "0"}], ",", 
     RowBox[{"equaz41", "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c2", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c4", ",", 
     RowBox[{"-", "8"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxFlwk4VG0bx8duhhmzGzPGtKDSItImOU8LIopUllZll9SLXpVWCWWP9u2V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   "], {{}, {}, 
    TagBox[
     TooltipBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110}]},
      RowBox[{
        RowBox[{
          RowBox[{"-", "10.025526434124851`"}], "+", 
          RowBox[{"1.6202644977447012`", " ", "c2"}], "-", 
          RowBox[{"2.6472756329334532`", " ", "c4"}]}], "\[Equal]", "0"}]],
     Annotation[#, -10.025526434124851` + 1.6202644977447012` $CellContext`c2 - 
       2.6472756329334532` $CellContext`c4 == 0, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
       LineBox[{111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
        123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
        137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
        151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
        165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
        179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
        193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 
        207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
        221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
        235, 236, 237, 238, 239, 240, 241, 242}], LineBox[CompressedData["
1:eJwV0UVCFAAAQNEZUAQRkJCuoaUE6VS6a0BKSkK6T8CZ6eaxeMu/+qH14/BR
MBAIXHDJFdfccMsd9zzwyBPPvPBKQBwkgkg+8JEoPhFNDJ+J5QtxxJPAVxJJ
IpkUvpFKGulkkEkW2eSQSx75hCigkCKKKaGUMr5TTgWVVFHND2qo5Sd11NNA
I00000IrbbTTQSe/+E0X3fTQSx/9DDDIEMOMMMoY40wwyRRhppnhD7PMMc8C
i/xliWVWWGWNf6yzwSZb/GebHXbZY58DDnmffswJp5xxzhseDClc
        "]]},
      RowBox[{
        RowBox[{
          RowBox[{"120.49948657710708`", "\[VeryThinSpace]"}], "+", 
          RowBox[{"1.9026444139673224`", " ", "c2"}], "-", 
          RowBox[{"3.5754633658618458`", " ", 
            SuperscriptBox["c2", "2"]}], "+", 
          RowBox[{"43.33287853282597`", " ", "c4"}], "+", 
          RowBox[{"5.932704670586379`", " ", 
            SuperscriptBox["c4", "2"]}]}], "\[Equal]", "0"}]],
     Annotation[#, 
      120.49948657710708` + 1.9026444139673224` $CellContext`c2 - 
       3.5754633658618458` $CellContext`c2^2 + 
       43.33287853282597 $CellContext`c4 + 
       5.932704670586379 $CellContext`c4^2 == 0, "Tooltip"]& ]}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-8, 8}, {-8, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soluz4", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"equaz31", "\[Equal]", "0"}], ",", "c4"}], "]"}], "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c4", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "0.37774683813029974`"}], " ", 
    RowBox[{"(", 
     RowBox[{"10.025526434124851`", "\[VeryThinSpace]", "-", 
      RowBox[{"1.6202644977447012`", " ", "c2"}]}], ")"}]}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equaz42", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"equaz41", "/.", "soluz4"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"41.481160111139886`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.9216861115516146`", " ", "c2"}], "-", 
  RowBox[{"1.3530428494748343`", " ", 
   SuperscriptBox["c2", "2"]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"equaz42", ",", 
   RowBox[{"{", 
    RowBox[{"c2", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJwt2Hc41t//B3B3kpkQSeE2SlZmKatz3PfbLCVllJFR+GT1IeFrU1GEZBZa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      "]]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-8, 8}, {-52.48706377774528, 41.63811940718935}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fraunhofer Examples", "Title"],

Cell["\<\
To use the Fraunhofer function you can either use directly the function \
Fraunhofer[thick, ind, diam, \[Theta], waves, focal] or use the interactive \
panel created by calling the function FraunhoferInputPanel[]. It let\
\[CloseCurlyQuote]s you to set input values and then call the Fraunhofer \
function. Moreover, it helps to load examples from the saved archives and set \
the output style.
Here are some examples\
\>", "Text"],

Cell["Fraunhofer 200-3000 (F/15) with BK7-F3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"thick", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"31", ",", " ", "3.31", ",", " ", "25.1"}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1", ",", " ", "1.51872218", ",", " ", "1", ",", " ", "1.61685", ",", 
        " ", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", " ", "1.52237649", ",", " ", "1", ",", " ", "1.62461", ",", 
        " ", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", " ", "1.51432242", ",", " ", "1", ",", " ", "1.60806", ",", 
        " ", "1"}], "}"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"diam", " ", "=", " ", "200"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", " ", "=", " ", "0.3"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"waves", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0.54607", ",", " ", "0.48613", ",", " ", "0.65627"}], "}"}]}], 
   ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"focal", " ", "=", " ", "3000"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Fraunhofer", "[", 
   RowBox[{
   "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ",
     "waves", ",", " ", "focal"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Fraunhofer", "[", 
   RowBox[{
   "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ",
     "waves", ",", " ", "focal", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Fraunhofer", "[", 
   RowBox[{
   "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ",
     "waves", ",", " ", "focal", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Fraunhofer", "[", 
   RowBox[{
   "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ",
     "waves", ",", " ", "focal", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Fraunhofer", "[", 
   RowBox[{
   "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ",
     "waves", ",", " ", "focal", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Fraunhofer 100-1500 (F/15) with BK7-F3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"thick", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"10", ",", " ", "0.5", ",", " ", "7"}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "1", ",", " ", "1.51872218", ",", " ", "1", ",", " ", "1.61685", ",", 
        " ", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", " ", "1.52237649", ",", " ", "1", ",", " ", "1.62461", ",", 
        " ", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", " ", "1.51432242", ",", " ", "1", ",", " ", "1.60806", ",", 
        " ", "1"}], "}"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"diam", " ", "=", " ", "100"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", " ", "=", " ", "0.5"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"waves", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0.54607", ",", " ", "0.48613", ",", " ", "0.65627"}], "}"}]}], 
   ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"focal", " ", "=", " ", "1500"}], ";"}], " "}]}], "Input"],

Cell[BoxData[
 RowBox[{"Fraunhofer", "[", 
  RowBox[{
  "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ", 
   "waves", ",", " ", "focal"}], "]"}]], "Input"],

Cell["Doublet Apoklass 100-1000 (F/10) with FK51-KZFSN2 ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"thick", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"10", ",", " ", "0.5", ",", " ", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.48794", ",", " ", "1", ",", " ", "1.56082", ",", " ", 
       "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.49056", ",", " ", "1", ",", " ", "1.56552", ",", " ", 
       "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.48480", ",", " ", "1", ",", " ", "1.55521", ",", " ", 
       "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", " ", "=", " ", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", " ", "0.5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0.54607", ",", " ", "0.48613", ",", " ", "0.65627"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"focal", " ", "=", " ", "1000"}], ";"}], "\n", 
 RowBox[{"Fraunhofer", "[", 
  RowBox[{
  "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ", 
   "waves", ",", " ", "focal"}], "]"}]}], "Input"],

Cell["Fraunhofer doublet 100 -1000 (F/10) with BaK1-FK54", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"thick", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"7", ",", " ", "0.5", ",", " ", "10"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.5725001", ",", " ", "1", ",", " ", "1.43700005", ",", 
       " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.57943481", ",", " ", "1", ",", " ", "1.44033746", ",",
        " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.56948667", ",", " ", "1", ",", " ", "1.43551944", ",",
        " ", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", " ", "=", " ", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", " ", "0.8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0.54607", ",", " ", "0.48613", ",", " ", "0.65627"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"focal", " ", "=", " ", "1000"}], ";"}], "\n", 
 RowBox[{"Fraunhofer", "[", 
  RowBox[{
  "thick", ",", " ", "ind", ",", " ", "diam", ",", " ", "\[Theta]", ",", " ", 
   "waves", ",", " ", "focal"}], "]"}]}], "Input"],

Cell["\<\
Fraunhofer doublet apo 100-1000 (F/10) con vetri KZFS N2- Fk51\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"thick", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"8", ",", " ", "0", ",", " ", "11"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.56081792", ",", " ", "1", ",", " ", "1.4879367", ",", 
       " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.5655173", ",", " ", "1", ",", " ", "1.49055758", ",", 
       " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", " ", "1.55520714", ",", " ", "1", ",", " ", "1.4847972", ",", 
       " ", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", " ", "=", " ", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", " ", "0.6"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0.54607", ",", " ", "0.48613", ",", " ", "0.65627"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"focal", " ", "=", " ", "1000"}], ";"}], "\n", 
 RowBox[{"Fraunhofer", "[", 
  RowBox[{
  "thick", ",", " ", "ind", ",", " ", "diam", ",", "\[Theta]", ",", " ", 
   "waves", ",", " ", "focal"}], "]"}]}], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<Fraunhofer\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Fraunhofer", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"FraunhoferInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Visible->True,
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 55, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[659, 26, 35, 0, 43, "Subsection"],
Cell[697, 28, 105, 2, 46, "Text"],
Cell[805, 32, 1622, 43, 303, "Text"],
Cell[2430, 77, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4577, 135, 40, 0, 43, "Subsection"],
Cell[4620, 137, 246, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4903, 148, 40, 0, 43, "Subsection"],
Cell[4946, 150, 111, 2, 46, "Text"],
Cell[5060, 154, 3193, 83, 551, "Text"],
Cell[8256, 239, 2296, 56, 473, "Text"],
Cell[10555, 297, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14069, 392, 82, 1, 71, "Title"],
Cell[14154, 395, 285, 5, 46, "Text"],
Cell[14442, 402, 867, 23, 77, "Input"],
Cell[15312, 427, 657, 17, 32, "Input"],
Cell[CellGroupData[{
Cell[15994, 448, 306, 9, 52, "Input"],
Cell[16303, 459, 441, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16781, 478, 452, 14, 52, "Input"],
Cell[17236, 494, 362, 13, 30, "Output"]
}, Open  ]],
Cell[17613, 510, 129, 3, 46, "Text"],
Cell[17745, 515, 615, 22, 55, "Input"],
Cell[18363, 539, 273, 10, 61, "Text"],
Cell[18639, 551, 579, 20, 55, "Input"],
Cell[CellGroupData[{
Cell[19243, 575, 306, 10, 32, "Input"],
Cell[19552, 587, 556, 19, 48, "Output"]
}, Open  ]],
Cell[20123, 609, 32, 0, 46, "Text"],
Cell[20158, 611, 427, 14, 32, "Input"],
Cell[20588, 627, 32, 0, 46, "Text"],
Cell[CellGroupData[{
Cell[20645, 631, 207, 6, 32, "Input"],
Cell[20855, 639, 1641, 51, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22533, 695, 305, 9, 55, "Input"],
Cell[22841, 706, 360, 12, 33, "Output"],
Cell[23204, 720, 338, 11, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23579, 736, 222, 6, 32, "Input"],
Cell[23804, 744, 813, 26, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24654, 775, 165, 4, 32, "Input"],
Cell[24822, 781, 28, 0, 30, "Output"]
}, Open  ]],
Cell[24865, 784, 41, 0, 46, "Text"],
Cell[CellGroupData[{
Cell[24931, 788, 216, 7, 32, "Input"],
Cell[25150, 797, 1574, 49, 33, "Output"]
}, Open  ]],
Cell[26739, 849, 236, 7, 32, "Input"],
Cell[CellGroupData[{
Cell[27000, 860, 177, 5, 35, "Input"],
Cell[27180, 867, 409, 13, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27626, 885, 177, 5, 35, "Input"],
Cell[27806, 892, 387, 12, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28230, 909, 177, 5, 32, "Input"],
Cell[28410, 916, 28, 0, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28475, 921, 150, 4, 32, "Input"],
Cell[28628, 927, 443, 14, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29108, 946, 150, 4, 32, "Input"],
Cell[29261, 952, 780, 26, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30078, 983, 353, 10, 35, "Input"],
Cell[30434, 995, 1482, 47, 33, "Output"]
}, Open  ]],
Cell[31931, 1045, 49, 0, 46, "Text"],
Cell[31983, 1047, 1116, 33, 70, "Input"],
Cell[CellGroupData[{
Cell[33124, 1084, 176, 5, 32, "Input"],
Cell[33303, 1091, 250, 6, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33590, 1102, 176, 5, 32, "Input"],
Cell[33769, 1109, 248, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34054, 1119, 181, 6, 32, "Input"],
Cell[34238, 1127, 194, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34469, 1136, 181, 6, 32, "Input"],
Cell[34653, 1144, 334, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35024, 1156, 330, 10, 32, "Input"],
Cell[35357, 1168, 377, 10, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35771, 1183, 197, 6, 32, "Input"],
Cell[35971, 1191, 180, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36188, 1200, 197, 6, 32, "Input"],
Cell[36388, 1208, 334, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36759, 1220, 329, 10, 32, "Input"],
Cell[37091, 1232, 439, 13, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37567, 1250, 386, 12, 32, "Input"],
Cell[37956, 1264, 10160, 179, 376, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48153, 1448, 186, 6, 32, "Input"],
Cell[48342, 1456, 281, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48660, 1469, 126, 3, 32, "Input"],
Cell[48789, 1474, 207, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49033, 1483, 167, 5, 32, "Input"],
Cell[49203, 1490, 7060, 129, 238, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56312, 1625, 36, 0, 71, "Title"],
Cell[56351, 1627, 441, 8, 94, "Text"],
Cell[56795, 1637, 54, 0, 46, "Text"],
Cell[56852, 1639, 1156, 37, 143, "Input"],
Cell[58011, 1678, 455, 11, 55, "Input"],
Cell[58469, 1691, 507, 12, 55, "Input"],
Cell[58979, 1705, 534, 12, 55, "Input"],
Cell[59516, 1719, 684, 15, 55, "Input"],
Cell[60203, 1736, 803, 19, 55, "Input"],
Cell[61009, 1757, 54, 0, 46, "Text"],
Cell[61066, 1759, 1171, 38, 143, "Input"],
Cell[62240, 1799, 182, 4, 32, "Input"],
Cell[62425, 1805, 66, 0, 46, "Text"],
Cell[62494, 1807, 1202, 35, 165, "Input"],
Cell[63699, 1844, 66, 0, 46, "Text"],
Cell[63768, 1846, 1219, 35, 165, "Input"],
Cell[64990, 1883, 86, 2, 46, "Text"],
Cell[65079, 1887, 1210, 35, 165, "Input"],
Cell[66292, 1924, 65, 0, 46, "Text"],
Cell[66360, 1926, 81, 1, 32, "Input"],
Cell[66444, 1929, 58, 1, 32, "Input"],
Cell[66505, 1932, 70, 0, 46, "Text"],
Cell[66578, 1934, 68, 1, 32, "Input"]
}, Open  ]]
}
]
*)

